define a = Character('[name]', color="#07ee07")
define b = Character('Сикорский', color="#f33629")
define c = Character('Алексей', color="#1612fa")
define d = Character('Марк', color="#43c5d6")
define i = Character('Михаил', color="#b52fd6")

# СОБЫТИЯ С ПЕРСООНАЖАМИ

# Александр

# Сикорский
#label :
    #if not items[""]:
        #""
        #""
    #else:
        #""
    #show screen location_screen
    #return

# Алексей

# Марк

# Михаил

default istoria = 0
default name = "Максим"

# СИСТЕМА ЗАДАЧ
default current_tasks = []  # Текущие задачи
default completed_tasks = []  # Выполненные задачи
default show_task_details = False  # Показывать ли детали задач

# ЭКРАН ЗАДАЧ
screen task_screen():
    zorder 100  # Высокий приоритет отображения
    vbox:
        xpos 20
        ypos 20
        spacing 5
        
        # Кнопка
        textbutton "ЗАДАЧИ":
            text_style "task_header"
            action ToggleVariable("show_task_details")
            
        # Детали задач 
        if show_task_details:
            frame:
                background Solid("#000000CC")  # Полупрозрачный черный фон
                padding (15, 15)
                xmaximum 400
                
                vbox:
                    spacing 10
                    
                    # Текущие задачи
                    text "ТЕКУЩИЕ:":
                        style "task_section"
                    
                    if current_tasks:
                        for task in current_tasks:
                            text "• " + task:
                                style "task_item"
                    else:
                        text "Нет текущих задач":
                            style "task_item"
                            color "#888888"
                    
                    # Разделитель
                    null height 10
                    
                    # Выполненные задачи
                    text "ВЫПОЛНЕННЫЕ:":
                        style "task_section"
                    
                    if completed_tasks:
                        for task in completed_tasks:
                            text "✓ " + task:
                                style "task_item"
                                color "#00FF00"
                    else:
                        text "Нет выполненных задач":
                            style "task_item"
                            color "#888888"

# Стили для экрана задач
style task_header:
    color "#FFFFFF"
    hover_color "#FFFF00"
    size 28
    bold True
    outlines [ (2, "#000000", 0, 0) ]

style task_section:
    color "#FFFFFF"
    size 20
    bold True
    outlines [ (1, "#000000", 0, 0) ]

style task_item:
    color "#FFFFFF"
    size 18
    outlines [ (1, "#000000", 0, 0) ]

# Экран ввода имени
screen name_input():
    modal True
    zorder 200
    frame:
        xalign 0.5
        yalign 0.5
        vbox:
            text "Введите ваше имя:"
            input:
                value VariableInputValue("name")
                length 15
            textbutton "OK":
                action Return()

# Определение изображений для локаций
image bg room = "room.jpg"
image bg kitchen = "kitchen.jpg"
image bg gorod = "gorod.png"

# СИСТЕМА ЛОКАЦИЙ
define locations = {
    "room": "bg room",           # Комната
    "kitchen": "bg kitchen",      # Кухня
    "gorod": "bg gorod"          # Город
}

# Текущая локация игрока
default current_location = "room"

# Состояния предметов (для инвентаря или состояний)
default items = {
    "bed_examined": False,
    "door_locked": False,
    "note_found": False
}

# ЭКРАН ЛОКАЦИИ
screen location_screen():
    zorder 10
    add locations[current_location]
    
    # === КОМНАТА ===
    if current_location == "room":
        imagebutton:
            xpos 40 ypos 568
            idle "strelanaobor"
            hover "strelanaobornig"
            action [SetVariable("current_location", "kitchen"), Hide("location_screen"), Show("location_screen")]
            
    # === КУХНЯ ===  
    if current_location == "kitchen":  # Заменил elif на if
        imagebutton:
            xpos 1610 ypos 568
            idle "strela"
            hover "strelanig"
            action [SetVariable("current_location", "room"), Hide("location_screen"), Show("location_screen")]

        # Кран
        imagebutton:
            xpos 140 ypos 430
            idle "kran"
            hover "krannig"
            action [Hide("location_screen"), Jump("examine_kran")]
    
    # === ГОРОД ===
    if current_location == "room":
        imagebutton:
            xpos 900 ypos 770
            idle "strelgorod"
            hover "strelgorodnao"
            action [SetVariable("current_location", "gorod"), Hide("location_screen"), Show("location_screen")]

# ВЗАИМОДЕЙСТВИЯ В КОМНАТЕ
label examine_bed:
    hide screen location_screen
    if not items["bed_examined"]:
        "Кровать не застелена. Как обычно."
        "На тумбочке лежит фотография..."
        $ items["bed_examined"] = True
    else:
        "Я уже осматривал кровать."
    show screen location_screen
    show screen task_screen
    return

label examine_table:
    hide screen location_screen
    "На столе разбросаны бумаги. Кажется, это чертежи."
    "Лучше не трогать пока."
    show screen location_screen
    show screen task_screen
    return

# ВЗАИМОДЕЙСТВИЯ НА КУХНЕ
label examine_fridge:
    hide screen location_screen
    "В холодильнике пусто. Похоже, пора идти за провизией."
    show screen location_screen
    show screen task_screen
    return

label examine_cabinet:
    hide screen location_screen
    if not items["note_found"]:
        "В шкафу нашлась записка!"
        $ items["note_found"] = True
    else:
        "Шкаф пуст."
    show screen location_screen
    show screen task_screen 
    return

label examine_kran: # Кран
    hide screen location_screen
    scene bg kitchen
    
    "{color=#00FF00}.Пьет.{/color}"
    a "Так-то лучше."
    $ istoria += 1
    
    if "Попить воды" in current_tasks:
        $ current_tasks.remove("Попить воды")
        $ completed_tasks.append("Попить воды")

    if istoria >= 1:
        a "Может быть потом мне надо будет выпить чая, но пока нет желания."

        jump ss
    else:
        a "Мне надо попить."

        show screen location_screen
        show screen task_screen
        return


# Игра начинается здесь:
label start:
    show screen task_screen
    
    "Приветствую вас в своей игре! Хотели бы вы ознакомиться с предысторией этой трилогии?"

    menu:
        "Приветствую вас в своей игре! Хотели бы вы ознакомиться с предысторией этой трилогии?"
        "ДА!":
            jump predistoria
        
        "Я думаю, что нет.":
            jump scip

label predistoria:
    scene black
"Пятьдесят Пять лет назад мир, каким мы его знали, оказался на грани катастрофы."
"В результате безрассудного эксперимента группы учёных, стремившихся создать идеальное оружие, был выпущен вирус 'Synthesis of Neuroparanoia'."
"Этот вирус, проникая в организм, подчинял мозг человека, превращая его в безумное существо, управляемое агрессией."
"Заражённые люди становились неузнаваемыми: их глаза ярко-краснели, а волосы растрепывались. Они нападали на своих близких, разрушали города и сеяли хаос, оставляя после себя лишь опустошение."
"В это время Сикорский был обычным школьником."
"Однажды, прогуливаясь по школьным коридорам, он забрел в туалет, где столкнулся с ужасной картиной."
"Его друг Дима, некогда весёлый и беззаботный, теперь стал жертвой вируса."
"Увидев его с растрепанными волосами и кровавыми глазами, Сикорский ощутил, как страх охватывает его."
"Дима, потерявший рассудок, напал на него с безумным криком."
"В этот момент, действуя на инстинкте, Сикорский захлопнул дверь туалета, преградив путь своему другу."
"Снаружи раздавались крики и шум, и вскоре он осознал, что вирус начал распространяться по школе, а затем и по всему городу. Паника охватила мир."
"Сикорский собрал группу выживших, таких же, как он."
"В ходе сражений Сикорский задавался философскими вопросами: {color=#00FF00}что значит быть человеком в мире, где человечность под угрозой?{/color}"
"{color=#00FF00}Какова цена жертвы ради спасения других?{/color}"
"Несмотря на то что им удалось истребить большую часть заражённых, некоторые из них остались, прячась в тенях и угрожая выжившим."
"Сикорский стал символом надежды и героизма, но его действия также поставили перед ним сложные моральные дилеммы."
"Он понимал, что его решения могут иметь далеко идущие последствия."
"После этих событий Сикорский исчез, и с тех пор никто не знал о его местонахождении."
"Его имя стало легендой, вдохновляя других на борьбу за выживание и задавая вопросы о природе добра и зла."
"Теперь, десять лет спустя, история Сикорского живёт в лагерях, где жители рассказывают о его подвигах у костра, смешивая правду с мифами."


label scip:
    call screen name_input
    
    show screen task_screen
    
    scene black

    show text "Шестьдесят Пять лет назад. Начало конца" at truecenter:
        alpha 0.0
        linear 1.0 alpha 1.0  # Появление за 1 секунду
        pause 2.0             # Показывать 2 секунды
        linear 1.0 alpha 0.0  # Исчезновение за 1 секунду
    pause 4.0  # Общая длительность анимации (1+2+1)

    play sound "audio/radiopriemnik-radiopomehi-26249.ogg" fadein 1.0
    play music "audio/legkiy-veter-35885.mp3" fadein 1.0

    scene black

    "...карантинная зона расширяется в связи с..."
    "...просим сохранять спокойствие..."
    "...все выжившие, направляйтесь в..."

    stop sound fadeout 2.0
    stop music fadeout 2.0

    play music "audio/Into-Oblivion(chosic.com).mp3" fadein 1.0
    scene black

    "{color=#ff0000}Трое силуэтов сидят вокруг чадящего костра.{/color}"

    "Женский голос" "Вы помните те дни, когда эпидемия только появилась."
    "Женский голос" "Первый кто с этим встретился... был Сикорский."

    "Мужской голос" "Говорят, он видел, как его друг Дима изменился."
    "Мужской голос" "Он превратился во что-то страшное..."
    "Мужской голос" "Глаза как горящие угли, когти вместо ногтей, а Сикорский... Видел это своими глазами. Никто уже не помнит что было после этого..."

    "Ребенок" "Всмысле? Но это же самое интересное! Очень жаль..."

    scene school

    "Женский голос" "Через неделю школа была эпицентром зоны. Через месяц — весь город. Сикорский вернулся спустя 2 года."

    scene hd_0af3857dd69d996b17de5d7f76882b24_68157946cd48c

    "Женский голос" "С отрядом таких же ненормальных. Говорят, они сожгли школу, но... Огонь горел зелёным. И кто знает, правда это, или ложь..."

    scene black

    "{color=#00FF00}.Звенит будильник.{/color}"
    "{color=#00FF00}.Время 7:30 утра.{/color}"
    "???"
    a "Что за черт? Где я?"
    
    show screen task_screen
    
    scene bg room

    a "А... Очередной кошмар..."
    a "Это моя... После таких снов мне нужно сходить на кухню и попить воды."
    $ current_tasks.append("Попить воды")

    show screen location_screen

    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()

    show screen task_screen

label ss:

    scene window

    a "Как же тяжело живется с тех самых пор как это началось."
    a "Выжившие разделились на 2 культуры."
    a "Первые - это выжившие которым понравилась жизнь мародерства. Они остались жить в кочующих поселениях."
    a "А есть второй тип. Они попытались вернуть прежний ритм жизни, который был до эпидемии."
    a "Этим типом, являюсь и я."
    
    scene bg room

    "Эх... Может стоит прогуляться?"

    show screen location_screen
    show screen task_screen

    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()

label gorod:
    a "Да-а, воздух все такой же тяжелый."
    a "Думаю с этим всеравно ничего не поделать."