# ОПРЕДЕЛЕНИЕ ПЕРСОНАЖЕЙ
define a = Character('[name]', color="#07ee07")
define b = Character('Сикорский', color="#f33629")
define c = Character('Алексей', color="#1612fa")
define d = Character('Марк', color="#43c5d6")
define i = Character('Михаил', color="#b52fd6")

# СИСТЕМА СУТОК - ОСНОВНЫЕ ПЕРЕМЕННЫЕ
default current_day = 0           # Текущий номер суток (начинаем с 0)
default is_daytime = True         # True = день, False = ночь
default day_events = {}           # Словарь для хранения событий по дням
default time_advanced = False     # Флаг для отслеживания смены времени

# СИСТЕМА ПРОГРЕССА ИГРЫ
default istoria = 0               # Прогресс сюжета
default name = "Максим"           # Имя игрока
default first_city_visit = True   # Флаг первого посещения города
default water_drunk = False       # Флаг для отслеживания, пил ли уже воду
default unblocking_computer = True # Флаг разблокировки компьютера

# СИСТЕМА ЗАДАЧ
default current_tasks = []        # Текущие активные задачи
default completed_tasks = []      # Выполненные задачи
default show_task_details = False # Показывать ли детали задач
default city_task_added = False   # Флаг добавления задачи "Выйти в город"

# ФУНКЦИИ ДЛЯ РАБОТЫ С ВРЕМЕНЕМ
init python:
    def advance_time():
        global is_daytime, current_day, time_advanced
        
        if is_daytime:
            # Переход от дня к ночи
            is_daytime = False
            time_advanced = True
            renpy.notify("Наступает ночь...")
        else:
            # Переход от ночи к новому дню
            is_daytime = True
            current_day += 1
            time_advanced = True
            renpy.notify("Наступает день " + str(current_day) + "...")
    
    def is_event_available(event_day, day_only=False, night_only=False):
        if day_only and not is_daytime:
            return False
        if night_only and is_daytime:
            return False
        if event_day != current_day:
            return False
        return True

# ЭКРАН ВВОДА ИМЕНИ
screen name_input():
    modal True
    zorder 200
    frame:
        xalign 0.5
        yalign 0.5
        vbox:
            text "Введите ваше имя:"
            input:
                value VariableInputValue("name")
                length 15
            textbutton "OK":
                action Return()

# ОПРЕДЕЛЕНИЕ ИЗОБРАЖЕНИЙ ДЛЯ ЛОКАЦИЙ
image bg room = "room.jpg"
image bg kitchen = "kitchen.jpg"
image bg gorod = "gorod.png"

# СИСТЕМА ЛОКАЦИЙ
define locations = {
    "room": "bg room",           # Комната
    "kitchen": "bg kitchen",     # Кухня
    "gorod": "bg gorod"          # Город
}

# ТЕКУЩАЯ ЛОКАЦИЯ ИГРОКА
default current_location = "room"

# СОСТОЯНИЯ ПРЕДМЕТОВ
default items = {
    "bed_examined": False,
    "door_locked": False,
    "note_found": False
}

# ЭКРАН ЗАДАЧ С ИНФОРМАЦИЕЙ О СУТКАХ
screen task_screen():
    zorder 100  # Высокий приоритет отображения
    vbox:
        xpos 20
        ypos 20
        spacing 5
        
        # === БЛОК ИНФОРМАЦИИ О СУТКАХ ===
        frame:
            background Solid("#000000CC")  # Полупрозрачный черный фон
            padding (10, 10)
            xmaximum 200
            
            vbox:
                spacing 2
                # Отображение номера суток
                text "СУТКИ: [current_day]":
                    style "task_section"
                    size 16
                
                # Отображение времени суток с разным цветом
                if is_daytime:
                    text "ДЕНЬ":
                        style "task_item"
                        color "#FFFF00"  # Желтый цвет для дня
                        size 14
                else:
                    text "НОЧЬ":
                        style "task_item"
                        color "#1E90FF"  # Синий цвет для ночи
                        size 14
        
        # === КНОПКА ПЕРЕКЛЮЧЕНИЯ ОТОБРАЖЕНИЯ ЗАДАЧ ===
        textbutton "ЗАДАЧИ":
            text_style "task_header"
            action ToggleVariable("show_task_details")
            
        # === ДЕТАЛИ ЗАДАЧ === 
        if show_task_details:
            frame:
                background Solid("#000000CC")
                padding (15, 15)
                xmaximum 400
                
                vbox:
                    spacing 10
                    
                    # Текущие задачи
                    text "ТЕКУЩИЕ:":
                        style "task_section"
                    
                    if current_tasks:
                        for task in current_tasks:
                            text "• " + task:
                                style "task_item"
                    else:
                        text "Нет текущих задач":
                            style "task_item"
                            color "#888888"
                    
                    # Разделитель
                    null height 10
                    
                    # Выполненные задачи
                    text "ВЫПОЛНЕННЫЕ:":
                        style "task_section"
                    
                    if completed_tasks:
                        for task in completed_tasks:
                            text "✓ " + task:
                                style "task_item"
                                color "#00FF00"  # Зеленый для выполненных
                    else:
                        text "Нет выполненных задач":
                            style "task_item"
                            color "#888888"

# СТИЛИ ДЛЯ ЭКРАНА ЗАДАЧ
style task_header:
    color "#FFFFFF"
    hover_color "#FFFF00"
    size 28
    bold True
    outlines [ (2, "#000000", 0, 0) ]

style task_section:
    color "#FFFFFF"
    size 20
    bold True
    outlines [ (1, "#000000", 0, 0) ]

style task_item:
    color "#FFFFFF"
    size 18
    outlines [ (1, "#000000", 0, 0) ]

# ЭКРАН ЛОКАЦИИ С УЧЕТОМ ВРЕМЕНИ СУТОК
screen location_screen():
    zorder 10
    
    # === НАЛОЖЕНИЕ ТЕМНОТЫ ДЛЯ НОЧИ ===
    if not is_daytime:
        add Solid("#000000AA")  # Полупрозрачный черный оверлей для ночи
    
    # === ОСНОВНОЕ ИЗОБРАЖЕНИЕ ЛОКАЦИИ ===
    add locations[current_location]
    
    # === КОМНАТА ===
    if current_location == "room":
        # Кнопка перехода на кухню
        imagebutton:
            xpos 40 ypos 568
            idle "strelanaobor"
            hover "strelanaobornig"
            action [SetVariable("current_location", "kitchen"), Hide("location_screen"), Show("location_screen")]
        
        # === КНОПКА СНА (ТОЛЬКО НОЧЬЮ) ===
        if not is_daytime:
            imagebutton:
                xpos 1000 ypos 300  # Координаты кровати
                idle "son"    # Изображение кровати в обычном состоянии
                hover "sonnao"  # Изображение кровати при наведении
                action [Hide("location_screen"), Jump("sleep_event")]
        
        # === КНОПКА ВЫХОДА В ГОРОД (ТОЛЬКО ДНЕМ И ПРИ УСЛОВИИ) ===
        if istoria >= 1 and is_daytime:
            imagebutton:
                xpos 900 ypos 770
                idle "strelgorod"
                hover "strelgorodnao"
                action [Hide("location_screen"), Jump("city_events")]
        
        # === КНОПКА КОМПЬЮТЕРА (ТОЛЬКО ДНЕМ И ПРИ УСЛОВИИ) ===
        if istoria >= 2 and is_daytime:
            imagebutton:
                xpos 1400 ypos 460
                idle "maxresdefault"
                hover "maxresdefaultnao"
                action [Hide("location_screen"), Jump("maxresdefault_events")]
            
    # === КУХНЯ ===  
    if current_location == "kitchen":
        # Кнопка возврата в комнату
        imagebutton:
            xpos 1610 ypos 568
            idle "strela"
            hover "strelanig"
            action [SetVariable("current_location", "room"), Hide("location_screen"), Show("location_screen")]

        # Кнопка крана (доступна всегда)
        imagebutton:
            xpos 140 ypos 430
            idle "kran"
            hover "krannig"
            action [Hide("location_screen"), Jump("examine_kran")]
    
    # === ГОРОД ===
    if current_location == "gorod":
        # Кнопка возврата в комнату
        imagebutton:
            xpos 900 ypos 770
            idle "strelkom"
            hover "strelkomnao"
            action [SetVariable("current_location", "room"), Hide("location_screen"), Show("location_screen")]

# ========== СОБЫТИЯ СИСТЕМЫ ВРЕМЕНИ ==========

label sleep_event:
    scene bg room
    
    # Проверяем, не пытается ли игрок спать днем
    if is_daytime:
        a "Сейчас день, я не хочу спать."
        jump game_loop
    
    a "Спокойной ночи..."
    
    # === СПЕЦИАЛЬНЫЕ НОЧНЫЕ СОБЫТИЯ ПО ДНЯМ ===
    if current_day == 1:
        "Мне снится тот самый кошмар с Сикорским..."
        "Этот сон повторяется уже который день..."
    elif current_day == 2:
        "Сегодня мне приснилось что-то странное..."
        "Какие-то голоса в темноте..."
    
    # Переход к следующему времени суток
    $ advance_time()
    
    # Сообщение в зависимости от нового времени
    if is_daytime:
        "Я просыпаюсь. Начинается новый день."
    else:
        "Я просыпаюсь. Снаружи все еще ночь."
    
    jump game_loop

# ========== СУЩЕСТВУЮЩИЕ СОБЫТИЯ С ДОБАВЛЕНИЕМ ПРОВЕРОК ВРЕМЕНИ ==========

label examine_kran:
    hide screen location_screen
    scene bg kitchen
    
    # Проверка времени (опционально - можно пить воду и ночью)
    if not is_daytime:
        a "Сейчас ночь. Может, не стоит шуметь на кухне?"
        jump game_loop
    
    if not water_drunk:
        "{color=#00FF00}.Пьет.{/color}"
        a "Так-то лучше."
        $ water_drunk = True
        $ istoria += 1
        
        # Обновление задач
        if "Попить воды" in current_tasks:
            $ current_tasks.remove("Попить воды")
            $ completed_tasks.append("Попить воды")

        if istoria >= 1:
            a "Может быть потом мне надо будет выпить чая, но пока нет желания."
            jump ss
    else:
        a "Я уже пил воду."
    
    jump game_loop

label city_events:
    hide screen location_screen
    scene bg gorod
    
    # Сначала меняем локацию на город
    $ current_location = "gorod"
    
    # Проверка - в город можно только днем
    if not is_daytime:
        a "Сейчас ночь. На улице слишком опасно."
        jump game_loop
    
    # Удаляем задачу "Выйти в город" только при первом посещении
    if "Выйти в город" in current_tasks:
        $ current_tasks.remove("Выйти в город")
        $ completed_tasks.append("Выйти в город")
    
    if first_city_visit:
        $ first_city_visit = False
        $ istoria += 1
        
        a "Да-а, воздух все такой же тяжелый."
        a "Думаю с этим всеравно ничего не поделать."

        "{color=#1E90FF}Пока я размышлял о происходящем, внезапно раздался вой сирен{/color}"
        "Внимание! Заражённые на стенах!"
        a "Черт! Это происходит снова."
        "{color=#1E90FF}Раз в неделю на нас обрушиватеся волны выживших тварей{/color}"
        "{color=#1E90FF}С каждым разом отбиваться становится все труднее{/color}"
        "{color=#1E90FF}В дали показался силуэт моего друга Алексея, я с ним дружу уже коло 12 лет{/color}"
        "{color=#00FF00}Алексей подходит к вам{/color}"
        c "Снова эта сирена. Невозможно нормально выспаться, твари."
        a "Думаешь в этот раз они смогут отбиться?"
        c "А хрен его знает, будем надеждаться."
        "{color=#1E90FF}Надо пойти домой и запустить комп{/color}"
        $ current_tasks.append("Сесть за комп")
        
        # Автоматический переход к ночи после событий в городе
        $ advance_time()
    
    jump game_loop

label maxresdefault_events:
    hide screen location_screen
    scene bg room

    # Проверяем, было ли уже показано это событие
    if unblocking_computer:
        # Обновление задач только при первом выполнении
        if "Сесть за комп" in current_tasks:
            $ current_tasks.remove("Сесть за комп")
            $ completed_tasks.append("Сесть за комп")

        $ unblocking_computer = False
        $ istoria += 1
        
        a "Это вот собственно мой компудахтер, дофига я работал ради того чтобы купить его."
        "..."
        "На этом версия 0.00003 заканчивается, спасибо что просмотрели возможное зарождение классной игры!"
        "Спасибо за игру!"
    else:
        # Повторное использование компьютера
        a "Я уже включал компьютер сегодня."
    
    jump game_loop

# ========== ОСНОВНАЯ ИГРА ==========

label start:
    show screen task_screen
    
    "Приветствую вас в своей игре! Хотели бы вы ознакомиться с предысторией этой трилогии?"

    menu:
        "Приветствую вас в своей игре! Хотели бы вы ознакомиться с предысторией этой трилогии?"
        "ДА!":
            jump predistoria
        
        "Я думаю, что нет.":
            jump scip

label predistoria:
    scene black
    "Пятьдесят Пять лет назад мир, каким мы его знали, оказался на грани катастрофы."
    "В результате безрассудного эксперимента группы учёных, стремившихся создать идеальное оружие, был выпущен вирус 'Synthesis of Neuroparanoia'."
    "Этот вирус, проникая в организм, подчинял мозг человека, превращая его в безумное существо, управляемое агрессией."
    "Заражённые люди становились неузнаваемыми: их глаза ярко-краснели, а волосы растрепывались. Они нападали на своих близких, разрушали города и сеяли хаос, оставляя после себя лишь опустошение."
    "В это время Сикорский был обычным школьником."
    "Однажды, прогуливаясь по школьным коридорам, он забрел в туалет, где столкнулся с ужасной картиной."
    "Его друг Дима, некогда весёлый и беззаботный, теперь стал жертвой вируса."
    "Увидев его с растрепанными волосами и кровавыми глазами, Сикорский ощутил, как страх охватывает его."
    "Дима, потерявший рассудок, напал на него с безумным криком."
    "В этот момент, действуя на инстинкте, Сикорский захлопнул дверь туалета, преградив путь своему другу."
    "Снаружи раздавались крики и шум, и вскоре он осознал, что вирус начал распространяться по школе, а затем и по всему городу. Паника охватила мир."
    "Сикорский собрал группу выживших, таких же, как он."
    "В ходе сражений Сикорский задавался философскими вопросами: {color=#00FF00}что значит быть человеком в мире, где человечность под угрозой?{/color}"
    "{color=#00FF00}Какова цена жертвы ради спасения других?{/color}"
    "Несмотря на то что им удалось истребить большую часть заражённых, некоторые из них остались, прячась в тенях и угрожая выжившим."
    "Сикорский стал символом надежды и героизма, но его действия также поставили перед ним сложные моральные дилеммы."
    "Он понимал, что его решения могут иметь далеко идущие последствия."
    "После этих событий Сикорский исчез, и с тех пор никто не знал о его местонахождении."
    "Его имя стало легендой, вдохновляя других на борьбу за выживание и задавая вопросы о природе добра и зла."
    "Теперь, десять лет спустя, история Сикорского живёт в лагерях, где жители рассказывают о его подвигах у костра, смешивая правду с мифами."

label scip:
    "Тогда удачной игры!"
    call screen name_input
    
    show screen task_screen
    
    scene black

    show text "Шестьдесят Пять лет назад. Начало конца" at truecenter:
        alpha 0.0
        linear 1.0 alpha 1.0  # Появление за 1 секунду
        pause 2.0             # Показывать 2 секунды
        linear 1.0 alpha 0.0  # Исчезновение за 1 секунду
    pause 4.0  # Общая длительность анимации (1+2+1)

    play sound "audio/radiopriemnik-radiopomehi-26249.ogg" fadein 1.0
    play music "audio/legkiy-veter-35885.mp3" fadein 1.0

    scene black

    "...карантинная зона расширяется в связи с..."
    "...просим сохранять спокойствие..."
    "...все выжившие, направляйтесь в..."

    stop sound fadeout 2.0
    stop music fadeout 2.0

    play music "audio/Into-Oblivion(chosic.com).mp3" fadein 1.0
    scene black

    "{color=#ff0000}Трое силуэтов сидят вокруг чадящего костра.{/color}"

    "Женский голос" "Вы помните те дни, когда эпидемия только появилась."
    "Женский голос" "Первый кто с этим встретился... был Сикорский."

    "Мужской голос" "Говорят, он видел, как его друг Дима изменился."
    "Мужской голос" "Он превратился во что-то страшное..."
    "Мужской голос" "Глаза как горящие угли, когти вместо ногтей, а Сикорский... Видел это своими глазами. Никто уже не помнит что было после этого..."

    "Ребенок" "Всмысле? Но это же самое интересное! Очень жаль..."

    scene school

    "Женский голос" "Через неделю школа была эпицентром зоны. Через месяц — весь город. Сикорский вернулся спустя 2 года."

    scene koster

    "Женский голос" "С отрядом таких же ненормальных. Говорят, они сожгли школу, но... Огонь горел зелёным. И кто знает, правда это, или ложь..."

    scene black

    "{color=#00FF00}.Звенит будильник.{/color}"
    "{color=#00FF00}.Время 7:30 утра.{/color}"
    "???"
    a "Что за черт? Где я?"
    
    show screen task_screen
    
    scene bg room

    a "А... Очередной кошмар..."
    a "Это моя комната... После таких снов мне нужно сходить на кухню и попить воды."
    $ current_tasks.append("Попить воды")

    show screen location_screen

    # Пауза для ознакомления с интерфейсом
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()
    $ renpy.pause()

    show screen task_screen

label ss:
    scene window

    a "Как же тяжело живется с тех самых пор как это началось."
    a "Выжившие разделились на 2 культуры."
    a "Первые - это выжившие которым понравилась жизнь мародерства. Они остались жить в кочующих поселениях."
    a "А есть второй тип. Они попытались вернуть прежний ритм жизни, который был до эпидемии."
    a "Этим типом, являюсь и я."
    
    scene bg room

label ss1:
    "Эх... Может стоит прогуляться?"

    # Добавляем задачу выйти в город только днем и если еще не добавлена
    if not city_task_added and is_daytime:
        $ current_tasks.append("Выйти в город")
        $ city_task_added = True

    jump game_loop

# ========== ГЛАВНАЯ ИГРОВАЯ ПЕТЛЯ ==========

label game_loop:
    show screen location_screen
    show screen task_screen
    pause
    jump game_loop